/*
  high level network api
  written by alexander yaworsky
  march '99
  september '99 - rewritten
*/

#include <windows.h>

#include "crc.h"
#include "stdlib.h"
#include "stringlist.h"
#include "network.h"
#include "switches.h"


void SendStringList( void* Ctx, STRINGLIST* s )
  {
    int   i, j, k, Failure;;
    ULONG Crc32, Len;
    char  Buf[ 512 ];
    //char  Buf[ 16 ];

    // calculate length and crc of string list
    Len = 0;
    CRC32_Init( Crc32 );
    for( i = 0; i < s->Count; i++ ) {
      j = lstrlen( s->Value[ i ] ) + 1;
      Len += j;
      for( k = 0; k < j; k++ ) CRC32_Upd( Crc32, s->Value[ i ][ k ] );
    }
    // send header
    Buf[1] = (char) Len;
    Buf[2] = (char) (Len >> 8);
    Buf[3] = (char) (Len >> 16);
    Buf[4] = (char) Crc32;
    Buf[5] = (char) (Crc32 >> 8);
    Buf[6] = (char) (Crc32 >> 16);
    Buf[7] = (char) (Crc32 >> 24);
    Buf[8] = 0;  // reserved
    Buf[9] = 0;  // reserved
    Buf[10] = 0; // reserved
    Buf[11] = 0; // reserved
    Buf[12] = 0; // reserved
    Buf[13] = 0; // reserved
    Buf[14] = 0; // reserved
    Buf[15] = 0; // reserved
    Buf[0] = CalculateCrc8( Buf + 1, 15 ); // set CRC8 field
    if( ! SendData( Ctx, Buf, 16 ) ) return;

    // send string list
    //for( i = 0; i < s->Count; i++ )
    //  if( ! SendData( Ctx, s->Value[ i ], lstrlen( s->Value[ i ] ) + 1 ) )
    //    return;

    // pack in packets for better performance
    Failure = 0;
    for( i = j = k = 0; i < s->Count; ) {
      Buf[ j ] = s->Value[ i ][ k++ ];
      if( Buf[ j ] == '\0' ) {
        i++; k = 0;
      }
      if( ++j == 512 ) {
        if( ! SendData( Ctx, Buf, 512 ) ) { Failure = 1; break; }
        j = 0;
      }
    }
    if( ! Failure ) SendData( Ctx, Buf, j );
  }

int RecvStringList( void* Ctx, STRINGLIST* s )
  {
    char  *cp, *data;
    ULONG OrgCrc32, Crc32, Len;
    int   i, Rc;
    char  Buf[ 16 ];

    if( ! RecvData( Ctx, Buf, 16 ) ) return ERRNET2_RECV;
    if( CalculateCrc8( Buf + 1, 15 ) != Buf[0] ) return ERRNET2_CRC;
    Len = (((unsigned)Buf[1]) & 255) +
          ((((unsigned)Buf[2]) & 255) << 8) +
          ((((unsigned)Buf[3]) & 255) << 16);
    OrgCrc32 = (((unsigned)Buf[4]) & 255) +
               ((((unsigned)Buf[5]) & 255) << 8) +
               ((((unsigned)Buf[6]) & 255) << 16) +
               ((((unsigned)Buf[7]) & 255) << 24);
    data = (char*) LocalAlloc( LMEM_FIXED, Len );
    if( data == NULL ) return ERRNET2_RECV;
    if( ! RecvData( Ctx, data, Len ) )
      Rc = ERRNET2_RECV;
    else {
      CRC32_Init( Crc32 );
      for( i = 0; i < Len; i++ ) CRC32_Upd( Crc32, data[ i ] );
      if( Crc32 != OrgCrc32 )
        Rc = ERRNET2_CRC;
      else {
        for( i = 0; i < Len; ) {
          cp = data + i;
          AddToStringList( s, cp );
          i += lstrlen( cp ) + 1;
        }
        Rc = ERRNET2_OK;
      }
    }
    LocalFree( data );
    return Rc;
  }

int RecvFile( void* Ctx, char* FileName, SRPRINT Callback )
  {
    HANDLE      Fh;
    FILETIME    Ftm, Ltm;
    SYSTEMTIME  Stm;
    char        Buf[ 512 ];
    int         i, j, Rc;
    long        Rcvd, FSz;
    ULONG       Crc32, OrgCrc32;
    DWORD       Attr;

    if( ! RecvData( Ctx, Buf, 16 ) ) return ERRNET2_RECV;
    if( CalculateCrc8( Buf + 1, 15 ) != Buf[0] ) return ERRNET2_CRC;
    FSz = (((unsigned)Buf[1]) & 255) +
          ((((unsigned)Buf[2]) & 255) << 8) +
          ((((unsigned)Buf[3]) & 255) << 16) +
          ((((unsigned)Buf[4]) & 255) << 24);
    Stm.wYear = (((unsigned)Buf[5]) & 255) +
                ((((unsigned)Buf[6]) & 255) << 8);
    Stm.wMonth = Buf[7];
    Stm.wDay = Buf[8];
    Stm.wHour = Buf[9];
    Stm.wMinute = Buf[10];
    Stm.wSecond = Buf[11];
    Stm.wMilliseconds = 0;
    Attr = (((unsigned)Buf[12]) & 255) +
                ((((unsigned)Buf[13]) & 255) << 8);
    SystemTimeToFileTime( &Stm, &Ltm );
    LocalFileTimeToFileTime( &Ltm, &Ftm );
    Fh = CreateFile( FileName, GENERIC_READ | GENERIC_WRITE,
                     0, NULL, OPEN_ALWAYS, 0, NULL );
    if( Fh == INVALID_HANDLE_VALUE ) return ERRNET2_OPEN;
    CRC32_Init( Crc32 );
    Rcvd = 0;
    Rc = ERRNET2_OK;
    while( Rcvd < FSz ) {
      if( FSz - Rcvd < 512 ) i = FSz - Rcvd; else i = 512;
      if( ! RecvData( Ctx, Buf, i ) ) {
        Rc = ERRNET2_RECV;
        break;
      }
      if( ! WriteFile( Fh, Buf, i, (LPDWORD) &j, NULL ) ) {
        Rc = ERRNET2_RW;
        break;
      }
      if( j != i ) {
        Rc = ERRNET2_RW;
        break;
      }
      for( j = 0; j < i; j++ ) CRC32_Upd( Crc32, Buf[ j ] );
      Rcvd += i;
      if( Callback != NULL ) {
        wsprintf( Buf, "%d of %d \r", Rcvd, FSz ); Callback( Buf );
      }
    }
    SetFileTime( Fh, NULL, NULL, &Ftm );
    CloseHandle( Fh );
    if( Rc == ERRNET2_OK ) {
      if( ! RecvData( Ctx, Buf, 4 ) )
        Rc = ERRNET2_RECV;
      else {
        OrgCrc32 = (((unsigned)Buf[0]) & 255) +
                   ((((unsigned)Buf[1]) & 255) << 8) +
                   ((((unsigned)Buf[2]) & 255) << 16) +
                   ((((unsigned)Buf[3]) & 255) << 24);
        if( OrgCrc32 != Crc32 ) Rc = ERRNET2_CRC;
      }
    }
    if( Rc != ERRNET2_OK ) DeleteFile( FileName );
    else if( Attr != 0 ) SetFileAttributes( FileName, Attr );
    if( Callback != NULL ) Callback( "\n" );
    return Rc;
  }

int SendFile( void* Ctx, char* FileName, SRPRINT Callback )
  {
    HANDLE      Fh;
    FILETIME    Ftm, Ltm;
    SYSTEMTIME  Stm;
    char        Buf[ 512 ];
    int         i, j, Rc;
    long        Sent, FSz;
    ULONG       Crc32;
    DWORD       Attr;

    Attr = GetFileAttributes( FileName );
    if( Attr == 0xFFFFFFFF ) Attr = FILE_ATTRIBUTE_NORMAL;
    Fh = CreateFile( FileName, GENERIC_READ,
                     FILE_SHARE_READ, NULL, OPEN_EXISTING, 0, NULL );
    if( Fh == INVALID_HANDLE_VALUE ) return ERRNET2_OPEN;
    if( ! GetFileTime( Fh, NULL, NULL, &Ftm ) ) {
      CloseHandle( Fh );
      return ERRNET2_RW;
    }
    FSz = GetFileSize( Fh, NULL );
    if( FSz == -1 ) {
      CloseHandle( Fh );
      return ERRNET2_RW;
    }
    FileTimeToLocalFileTime( &Ftm, &Ltm );
    FileTimeToSystemTime( &Ltm, &Stm );
    Buf[1] = (char) FSz;
    Buf[2] = (char) (FSz >> 8);
    Buf[3] = (char) (FSz >> 16);
    Buf[4] = (char) (FSz >> 24);
    Buf[5] = (char) Stm.wYear;
    Buf[6] = (char) (Stm.wYear >> 8);
    Buf[7] = (char) Stm.wMonth;
    Buf[8] = (char) Stm.wDay;
    Buf[9] = (char) Stm.wHour;
    Buf[10] = (char) Stm.wMinute;
    Buf[11] = (char) Stm.wSecond;
    Buf[12] = (char) Attr;
    Buf[13] = (char) (Attr >> 8);
    Buf[14] = 0; // reserved
    Buf[15] = 0; // reserved
    Buf[0] = CalculateCrc8( Buf + 1, 15 ); // set CRC8 field
    if( ! SendData( Ctx, Buf, 16 ) ) {
      CloseHandle( Fh );
      return ERRNET2_SEND;
    }
    CRC32_Init( Crc32 );
    Sent = 0;
    Rc = ERRNET2_OK;
    while( Sent < FSz ) {
      if( FSz - Sent < 512 ) i = FSz - Sent; else i = 512;
      if( ! ReadFile( Fh, Buf, i, (LPDWORD) &j, NULL ) ) {
        Rc = ERRNET2_RW;
        break;
      }
      if( j != i ) {
        Rc = ERRNET2_RW;
        break;
      }
      if( ! SendData( Ctx, Buf, i ) ) {
        Rc = ERRNET2_SEND;
        break;
      }
      for( j = 0; j < i; j++ ) CRC32_Upd( Crc32, Buf[ j ] );
      Sent += i;
      if( Callback != NULL ) {
        wsprintf( Buf, "%d of %d \r", Sent, FSz ); Callback( Buf );
      }
    }
    CloseHandle( Fh );
    if( Rc == ERRNET2_OK ) {
      Buf[0] = (char) Crc32;
      Buf[1] = (char) (Crc32 >> 8);
      Buf[2] = (char) (Crc32 >> 16);
      Buf[3] = (char) (Crc32 >> 24);
      if( ! SendData( Ctx, Buf, 4 ) ) Rc = ERRNET2_SEND;
    }
    if( Callback != NULL ) Callback( "\n" );
    return Rc;
  }
